// Created by Newton Book Maker 1.1
//  Note: This file may contain needed resources !! 
// Document
book := {
	version: 2,
	isbn: "ISBN8:39:48 PM",
	help: TRUE,
	contents: Array(18, NIL),
	styles: [],
	browsers: [], templates: [], rendering: []};
//output.book := book;
//output.help := TRUE;

// Shared Map Functions
func MakePage(aTemplate)
	{template: aTemplate, blocks: []};
func MakeBlock(aBounds, anItem)
	{bounds: aBounds, item: anItem};

// Shared Scripts
gotoDestScript := func() begin
	if (curRendering = 0) then :TurnToPage(destPage);
	else :TurnToPage(:FindPageByContent(kioskDest, 0, NIL));
end;

// Text Styles
s0 := {
	family: 'Geneva,
	face: 0,
	size: 9};
AddArraySlot(book.styles, s0);

s1 := {
	family: 'espy /* Courier */,
	face: 0,
	size: 10};
AddArraySlot(book.styles, s1);

s2 := {
	family: 'Espy,
	face: 0,
	size: 10};
AddArraySlot(book.styles, s2);

s3 := {
	family: 'Espy,
	face: 0,
	size: 14};
AddArraySlot(book.styles, s3);

s4 := {
	family: 'Espy,
	face: 1,
	size: 10};
AddArraySlot(book.styles, s4);

s5 := {
	family: 'espy /* Courier */,
	face: 2,
	size: 10};
AddArraySlot(book.styles, s5);


// Contents
c1 := {
	data: "Der EnRoute Regel-Editor",
	styles: [24, s4, 1, s2],
	layout: 32
};
book.contents[0] := c1;

c2 := {
	data: "Im folgenden finden Sie die wichtigsten Informationen zum EnRoute Regel-Editor. Weitergehende Informationen finden Sie in der gedruckten Dokumentation.

Der Regel-Editor wird mit EnRoute i-net geliefert. Er befindet sich im Ordner \"Einstellungen\" in den \"Extras\".
",
	viewFont: s2
};
book.contents[1] := c2;

c3 := {
	data: "Verwenden von Regeln",
	styles: [20, s4, 1, s2],
	layout: 32
};
book.contents[2] := c3;

c4 := {
	data: "Mit dem Regel-Editor knnen Sie Regelstze erstellen, um diese im Modul \"Regel-Filter fr Nachrichten\" zu verwenden.

EnRoute kann mit diesem Zusatzmodul E-Mail-Nachrichten filtern, d.h. in Abhngigkeit von Kriterien empfangen oder auch ablehnen.

Der Regel-Editor wird nur fr die Erstellung dieser Regelstze bentigt. Fr die Funktion des Regel-Filters selbst ist er nicht ntig.",
	viewFont: s2
};
book.contents[3] := c4;

c5 := {
	data: "Erstellen neuer Regeln",
	styles: [22, s4, 1, s2],
	layout: 32
};
book.contents[4] := c5;

c6 := {
	data: "Tippen Sie im Regel-Editor auf die Taste \"Neu\". Ein leeres Formular mit einem neuen Regelsatz wird angezeigt. 

Tippen Sie im Formular auf die Taste \"Regeln\", um eine neue Regel zu erstellen. Ein Zettel wird angezeigt, in dem Sie die Regel-Kriterien festlegen knnen.
",
	viewFont: s2
};
book.contents[5] := c6;

c7 := {
	data: "Festlegen der Regel-Kriterien",
	styles: [29, s4, 1, s2],
	layout: 32
};
book.contents[6] := c7;

c8 := {
	data: "Im Regel-Zettel finden Sie drei Einblendlisten und eine Zeile zur Texteingabe. Die ersten beiden Einblendlisten und die Eingabezeile enthalten den \"Wenn\"-Teil einer Filteregel. Durch die Auswahl eines Eintrages aus der ersten Liste bestimmen Sie, welche weiteren Auswahlmglichkeiten zur Verfgung stehen.

Eine oder mehrere Regeln, die im Regel-Formular festgelegt wurden, werden als Regelsatz bezeichnet. Ein Regelsatz enthlt maximal 24 Regeln.",
	viewFont: s2
};
book.contents[7] := c8;

c9 := {
	data: "Anordnen von Regeln",
	viewFont: s4,
	layout: 32
};
book.contents[8] := c9;

c10 := {
	data: "Regelstze sind hierarchisch angelegt, d.h. die Reihenfolge der Regeln ist sehr wichtig. Eine eingehende Nachricht wird mit der ersten Regel im Regelsatz abgeglichen. Wenn die Regel zutrifft, werden die restlichen Regeln NICHT angewendet.

Wenn Sie die Reihenfolge der Regeln ndern wollen, tippen Sie auf den Punkt der Regel, die Sie umstellen mchten, und ziehen Sie diese an die gewnschte Position.
",
	viewFont: s2
};
book.contents[9] := c10;

c11 := {
	data: "Lschen von Regeln",
	viewFont: s4,
	layout: 32
};
book.contents[10] := c11;

c12 := {
	data: "Wenn Sie eine Regel lschen wollen, streichen Sie diese mit einer Zickzacklinie durch.
",
	viewFont: s2
};
book.contents[11] := c12;

c13 := {
	data: "Benennen und Ablegen von Regelstzen",
	styles: [36, s4, 1, s2],
	layout: 32
};
book.contents[12] := c13;

c14 := {
	data: "Zur spteren Verwendung eines Regelsatzes sollten Sie diesen benennen, indem Sie auf die Bildtaste oben links im Zettel tippen.

Sie legen einen Regelsatz ab, indem Sie auf den Ordner unten rechts im Zettel tippen.

Mit EnRoute i-net knnen Sie jeweils nur einen Regelsatz auswhlen. Whlen Sie keinen Regelsatz aus, wird der Regel-Filter deaktiviert.
",
	viewFont: s2
};
book.contents[13] := c14;

c15 := {
	data: "Weitere Funktionen",
	viewFont: s4,
	layout: 32
};
book.contents[14] := c15;

c16 := {
	data: "Wenn Sie einen Regelsatz verwenden wollen, der sich auf einer Speicherkarte befindet, whlen Sie den Satz mit dem Regel-Filter fr Nachrichten aus, bevor Sie die Karte aus dem Gert nehmen.

Eine Nachricht wird geladen, wenn keine Regeln aus einem Regelsatz auf sie zutrifft. Sie knnen das verhindern, indem Sie eine letzte Regel erstellen, mit der Nachrichten bersprungen werden, wenn sie grsser als zwei Byte sind.
",
	viewFont: s2
};
book.contents[15] := c16;

c17 := {
	data: "Nur Vorspann lesen",
	viewFont: s4,
	layout: 32
};
book.contents[16] := c17;

c18 := {
	data: "Wenn Sie den POP-Listenmanager-Vorspann ohne die zugehrige Nachricht lesen mchten, erstellen Sie einen Regelsatz mit einer einzigen Regel, mit der Nachrichten bersprungen werden, die grsser als zwei Byte sind.
",
	viewFont: s2
};
book.contents[17] := c18;


// Kiosk (menu page) references

// Page Templates
NBMDefault := {
	nColumns: 1,
	column: [{
	width: 12,
	type: 0}]
};
AddArraySlot(book.templates, NBMDefault);

// Bounds List
bnd1 := [0,0,206,14];
bnd2 := [0,14,206,214];
bnd3 := [0,0,206,28];
bnd4 := [0,28,206,214];
bnd5 := [0,14,206,112];

// Pages
pageList := {pageSize: {left: 0, top: 0, right: 206, bottom: 214}, pages: []};

// Page 1
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c1));
AddArraySlot(page.blocks, MakeBlock(bnd2, c2));
AddArraySlot(pageList.pages, page);

// Page 2
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c3));
AddArraySlot(page.blocks, MakeBlock(bnd2, c4));
AddArraySlot(pageList.pages, page);

// Page 3
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c5));
AddArraySlot(page.blocks, MakeBlock(bnd2, c6));
AddArraySlot(pageList.pages, page);

// Page 4
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c7));
AddArraySlot(page.blocks, MakeBlock(bnd2, c8));
AddArraySlot(pageList.pages, page);

// Page 5
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c9));
AddArraySlot(page.blocks, MakeBlock(bnd2, c10));
AddArraySlot(pageList.pages, page);

// Page 6
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c11));
AddArraySlot(page.blocks, MakeBlock(bnd2, c12));
AddArraySlot(pageList.pages, page);

// Page 7
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd3, c13));
AddArraySlot(page.blocks,
	{bounds: bnd4,
	item: c14,
	dataLen: 351});
AddArraySlot(pageList.pages, page);

// Page 8
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c15));
AddArraySlot(page.blocks, MakeBlock(bnd2, c16));
AddArraySlot(pageList.pages, page);

// Page 9
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c17));
AddArraySlot(page.blocks, MakeBlock(bnd5, c18));
AddArraySlot(pageList.pages, page);

AddArraySlot(book.rendering, pageList);

// Browsers & Page Hints
b1 := {
	name: "Contents",  list: []
};


AddArraySlot(b1.list, {	// 0
	item: c1
});
AddArraySlot(b1.list, {	// 1
	item: c3
});
AddArraySlot(b1.list, {	// 2
	item: c5
});
AddArraySlot(b1.list, {	// 3
	item: c7
});
AddArraySlot(b1.list, {	// 4
	item: c9
});
AddArraySlot(b1.list, {	// 5
	item: c11
});
AddArraySlot(b1.list, {	// 6
	item: c13
});
AddArraySlot(b1.list, {	// 7
	item: c15
});
AddArraySlot(b1.list, {	// 8
	item: c17
});
AddArraySlot(book.browsers, b1);

// Indices and Sub-Indices
